package gov.va.med.mhv.vitals.service.impl;

import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.converter.LipidsConverter;
import gov.va.med.mhv.vitals.dto.LipidsReadingDTO;
import gov.va.med.mhv.vitals.model.LipidsReading;
import gov.va.med.mhv.vitals.repository.LipidsReadingRepository;
import gov.va.med.mhv.vitals.service.LipidsService;
import gov.va.med.mhv.vitals.validator.LipidsValidator;

@Component
public class LipidsServiceImpl implements LipidsService {
	
	private static Logger log = LogManager.getLogger(LipidsServiceImpl.class);
	
	@Autowired
	private LipidsReadingRepository lipidRepository;
	
	@Autowired
	private LipidsValidator validator;


	@Override
	public ResponseUtil<Long> save(LipidsReadingDTO lipidDTO) {
		ResponseUtil<Long> response = new ResponseUtil<Long>();
		response.setValidationErrors(new LinkedHashMap<String, String>());
		validator.lipidValidations(response, lipidDTO);
		if(response.getValidationErrors().size() == 0){
			LipidsReading lpReading = LipidsConverter.convertLipidReadingDTO(lipidDTO);
			lpReading = lipidRepository.save(lpReading);
			response.setSuccess(true);
			response.setPojoObject(lpReading.getId());
		}else{
			log.debug("Validation Errors in save Lipids reading:");
			response.setFailure(true);
		}
		return response;
	}

	@Override
	public ResponseUtil<Void> delete(Long id) {
		ResponseUtil<Void> response = new ResponseUtil<Void>();
		lipidRepository.delete(id);
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil findByPrimaryKey(Long id) {
		ResponseUtil response = new ResponseUtil();
		LipidsReading lpReading = lipidRepository.findOne(id);
		if(lpReading != null){
			LipidsReadingDTO lipidDTO = LipidsConverter.convertLipidReadingDomain(lpReading);
			response.setPojoObject(lipidDTO);
			response.setSuccess(true);
		}else{
			log.debug("Lipids Record not found for id:");
			log.debug(id);
		}
		return response;
	}

	@Override
	public ResponseUtil<List<LipidsReadingDTO>> getLipidReadingsForUser(Long userprofileid) {
		ResponseUtil<List<LipidsReadingDTO>> response = new ResponseUtil<List<LipidsReadingDTO>>();
		List<LipidsReading> lpReadings=lipidRepository.getLipidsReadingsForUser(userprofileid);
		if(lpReadings != null){
			List<LipidsReadingDTO> dtos = LipidsConverter.convertLipidReadings(lpReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Lipids Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<List<LipidsReadingDTO>> getLipidDashBoardReadingsForUser(Long userprofileid) {
		ResponseUtil<List<LipidsReadingDTO>> response = new ResponseUtil<List<LipidsReadingDTO>>();
		Pageable topFive = new  PageRequest(0,5);
		List<LipidsReading> lpReadings=lipidRepository.getDashBoardLipidsReadingsForUser(userprofileid, topFive);
		if(lpReadings != null){
			List<LipidsReadingDTO> dtos = LipidsConverter.convertLipidReadings(lpReadings);
			response.setPojoObject(dtos);
		}else{
			log.debug("Lipids Records not found for userprofileid:");
			log.debug(userprofileid);
		}
		response.setSuccess(true);
		return response;
	}

	@Override
	public ResponseUtil<LipidsReadingDTO> getLipidReadingByid(Long userProfileId, Long id) {
		ResponseUtil<LipidsReadingDTO> response = new ResponseUtil<LipidsReadingDTO>();
		LipidsReading lpReading = lipidRepository.findOne(id);
		if(lpReading != null){
			LipidsReadingDTO dto=LipidsConverter.convertLipidReadingDomain(lpReading);
			response.setPojoObject(dto);
		}else{
			log.debug("Lipid Record not found for Id:");
			log.debug(id);
		}
		response.setSuccess(true);
		return response;
	}

}
